-----------
-- Hometown
-----------

-- Exit to Accuracy Gym
local ExitToAccuracy = function()
	SRT.Transition.NextMap="AccuracyGym"
	SRT.Transition.NextPos={ r=9, d=11, z=-1 }
	SRT.MapFade:queuecommand("FadeOut")
end

-- Exit to Stamina Gym
local ExitToStamina = function()
	SRT.Transition.NextMap="StaminaGym"
	SRT.Transition.NextPos={ r=9, d=11, z=-1 }
	SRT.MapFade:queuecommand("FadeOut")
end

-- Exit to Footspeed Gym
local ExitToFootspeed = function()
	SRT.Transition.NextMap="FootspeedGym"
	SRT.Transition.NextPos={ r=9, d=11, z=-1 }
	SRT.MapFade:queuecommand("FadeOut")
end

-- Exit to Ending
local ExitToEnding = function()
	SRT.Dialog.Box:playcommand("Hide")
	SRT.MapFade:playcommand("EndGame1")
end

----------------------------------------------------------------------------------------------------
-- NPCs

local Jonx = setmetatable({},NPC):new( 27, 48, "Jonx 1x4.png", "Down" )
Jonx.Action = function()
	SRT.Dialog.Words = {
		{text=THEME:GetString("Hometown-Jonx","1")},
		{text=THEME:GetString("Hometown-Jonx","2")},
		{text=THEME:GetString("Hometown-Jonx","3")},
		{text=THEME:GetString("Hometown-Jonx","4")},
		{text=THEME:GetString("Hometown-Jonx","5")},
	}
	StartDialog("#666666", "Jonx")
end


local Sujeet = setmetatable({},NPC):new( 14, 33, "Sujeet 1x4.png", "Right" )
Sujeet.Action = function()
	SRT.Dialog.Words = {
		{text=THEME:GetString("Hometown-Sujeet","1")},
		{text=THEME:GetString("Hometown-Sujeet","2")},
	}
	StartDialog("#666666", "Sujeet")
end


local Demir = setmetatable({},NPC):new( 24, 38, "Demir 1x4.png", "Up" )
Demir.Action = function()
	SRT.Dialog.Words = {
		{text=THEME:GetString("Hometown-Demir","1")},
		{text=THEME:GetString("Hometown-Demir","2")},
		{text=THEME:GetString("Hometown-Demir","3")},
		{text=THEME:GetString("Hometown-Demir","4")},
		{text=THEME:GetString("Hometown-Demir","5")},
	}
	StartDialog("#666666", "Demir")
end


local Dyle = setmetatable({},NPC):new( 33, 28, "Dyle 1x4.png", "Down" )
Dyle.Action = function()
	SRT.Dialog.Words = {
		{text=THEME:GetString("Hometown-Dyle","1")},
		{text=THEME:GetString("Hometown-Dyle","2")},
	}
	StartDialog("#666666", "Dyle")
end


local Patti = setmetatable({},NPC):new( 28, 21, "Patti 1x4.png", "Down" )
Patti.Action = function()
	SRT.Dialog.Words = {
		{
			text=THEME:GetString("Hometown-Patti","1"),
			choices={
				THEME:GetString("Hometown-Patti","1-Choice1"),
				THEME:GetString("Hometown-Patti","1-Choice2"),
			}
		},
		{
			text=function()
				if SRT.Dialog.ChoiceIndex == 1 then
					SOUND:PlayOnce(THEME:GetPathS("","sfx/photograph.ogg"))
					return THEME:GetString("Hometown-Patti","2-1")
				elseif SRT.Dialog.ChoiceIndex == 2 then
					return THEME:GetString("Hometown-Patti","2-2")
				end
			end
		}
	}

	StartDialog("#666666", "Patti")
end

local Richard = setmetatable({},NPC):new( 22, 25, "Richard 1x4.png", "Down" )
Richard.Action = function()
	SRT.Dialog.Words = {
		{
			text=function()
				if SRT.Player.Name == "Richerd" then
					return THEME:GetString("Hometown-Richard","1-1")
				else
					return THEME:GetString("Hometown-Richard","1-2")
				end
			end
		}
	}
	StartDialog("#666666", "Richerd")
end

local Pat = setmetatable({},NPC):new( 25, 44, "Pat 1x4.png", "Right" )
Pat.Action = function()
	SRT.Dialog.Words = {
		{text=THEME:GetString("Hometown-Pat","1")},
		{text=THEME:GetString("Hometown-Pat","2")},
		{text=THEME:GetString("Hometown-Pat","3")},
		{text=THEME:GetString("Hometown-Pat","4")},
		{text=THEME:GetString("Hometown-Pat","5")},
		{text=THEME:GetString("Hometown-Pat","6")},
		{text=THEME:GetString("Hometown-Pat","7")},
		{text=THEME:GetString("Hometown-Pat","8")},
		{text=THEME:GetString("Hometown-Pat","9")},
	}
	StartDialog("#666666", "Pat")
end

local Caitlin = setmetatable({},NPC):new( 38, 19, "Caitlin 1x4.png", "Right" )
Caitlin.Action = function()
	SRT.Dialog.Words = {
		{text=THEME:GetString("Hometown-Caitlin","1")},
		{text=THEME:GetString("Hometown-Caitlin","2")},
	}
	StartDialog("#666666", "Caitlin")
end



--------------------------------------------------------------------------------
-- EndGame NPCs


local MadMatt = setmetatable({},NPC):new( -1, 50, "MadMatt 4x4.png", "Down" )
MadMatt.Action = function() end

local Archi = setmetatable({},NPC):new( 52, 51, "Archi 4x4.png", "Left" )
Archi.Action = function() end

local LittleMatt = setmetatable({},NPC):new( 52, 52, "LittleMatt 4x4.png", "Left" )
LittleMatt.Action = function() end






local Sami = setmetatable({},NPC):new( 39, 49, "Sami 4x4.png", "Down" )
Sami.Action = function()
	SRT.Dialog.Words = {
		{ text=THEME:GetString("Endgame-Sami","3") },
		{ text=THEME:GetString("Endgame-Sami","4") },
		{ text=THEME:GetString("Endgame-Sami","5") },
		{ text=THEME:GetString("Endgame-Sami","6") },

		{
			text=function()
				SRT.OverFog:linear(1):diffusealpha(0.4)
				local audio_path = THEME:GetPathS("Overworld", "music (loop)/Pre-Ending.ogg")
				SOUND:PlayMusicPart( audio_path, 0, 28.75, 0, 0, true, false, false )

				SRT.Dialog.Speaker = "Archi"
				SRT.Dialog.Box:playcommand("UpdateColor", {Color=color("#73ca6d")}):playcommand("UpdateSpeaker")
				SRT.EventActors[10]:playcommand("AnimationOn")
					:playcommand("Walk", {Dir="Left",Duration=2,r=36,d=51})
					:playcommand("Walk", {Dir="Up",Duration=0.25,r=36,d=49})
					:playcommand("Walk", {Dir="Left",Duration=0,r=36,d=49})
					:queuecommand("TurnRight")

				return THEME:GetString("Endgame-Archi","1")
			end
		},
		{
			text=function()
				SRT.OverFog:linear(1):diffusealpha(0.33)
				SRT.Dialog.Speaker = "Mad Matt"
				SRT.Dialog.Box:playcommand("UpdateColor", {Color=color("#bc4848")}):playcommand("UpdateSpeaker")
				SRT.EventActors[9]:playcommand("AnimationOn")
					:playcommand("Walk", {Dir="Right",Duration=1,r=36,d=50})

					return THEME:GetString("Endgame-MadMatt","1")
			end
		},
		{
			text=function()
				SRT.OverFog:linear(1):diffusealpha(0.25)
				SRT.Dialog.Speaker = "Little Matt"
				SRT.Dialog.Box:playcommand("UpdateColor", {Color=color("#4898e8")}):playcommand("UpdateSpeaker")
				SRT.EventActors[11]:playcommand("AnimationOn")
					:playcommand("Walk", {Dir="Left",Duration=2.5,r=35,d=52})
					:playcommand("Walk", {Dir="Up",Duration=0.125,r=35,d=51})
					:playcommand("Walk", {Dir="Left",Duration=0.125,r=35,d=50})
					:queuecommand("TurnRight")

					return THEME:GetString("Endgame-LittleMatt","1")
			end
		},
		{ text=THEME:GetString("Endgame-LittleMatt","2") },
		{
			text=function()
				SRT.OverFog:linear(1):diffusealpha(0.2)
				SRT.Dialog.Speaker = "Archi"
				SRT.Dialog.Box:playcommand("UpdateColor", {Color=color("#73ca6d")}):playcommand("UpdateSpeaker")
				return THEME:GetString("Endgame-Archi","2")
			end
		},
		{
			text=function()
				SRT.OverFog:linear(1):diffusealpha(0.1)
				SRT.Dialog.Speaker = "Mad Matt"
				SRT.Dialog.Box:playcommand("UpdateColor", {Color=color("#bc4848")}):playcommand("UpdateSpeaker")
				return THEME:GetString("Endgame-MadMatt","2")
			end
		},
		{
			text=function()
				SRT.OverFog:linear(1):diffusealpha(0)
				SRT.Dialog.Speaker = "Sami"
				SRT.Dialog.Box:playcommand("UpdateColor", {Color=color("#e5af12")}):playcommand("UpdateSpeaker")
				return THEME:GetString("Endgame-Sami","7")
			end
		},
		{ text=THEME:GetString("Endgame-Sami","8") },
		{
			text=function()
				SRT.Dialog.Speaker = "(All)"
				SRT.Dialog.Box:playcommand("UpdateColor", {Color=color("#666666")}):playcommand("UpdateSpeaker")
				return THEME:GetString("Endgame-Sami","9")
			end
		},
		{
			text=function()
				ExitToEnding()
				return ""
			end
		}
	}
	StartDialog("#e5af12", "Sami")
end








local Events = {

	--exit map to Stamina Gym (left)
	{
		Tile = { r=14, d=4 },
		Trigger = "PlayerTouch",
		Action = ExitToStamina
	},
	{
		Tile = { r=15, d=4 },
		Trigger = "PlayerTouch",
		Action = ExitToStamina
	},

	--exit map to Accuracy Gym (middle)
	{
		Tile = { r=25, d=6 },
		Trigger = "PlayerTouch",
		Action = ExitToAccuracy
	},
	{
		Tile = { r=26, d=6 },
		Trigger = "PlayerTouch",
		Action = ExitToAccuracy
	},

	--exit map to Footspeed Gym (right)
	{
		Tile = { r=36, d=4 },
		Trigger = "PlayerTouch",
		Action = ExitToFootspeed
	},
	{
		Tile = { r=37, d=4 },
		Trigger = "PlayerTouch",
		Action = ExitToFootspeed
	},

	-- town square Fountain
	setmetatable({}, AnimatedSprite):new(24, 35, "fountain", 0.09),
}

-- NPCs
if not IsEndGame() then
	Events[#Events+1] = Jonx
	Events[#Events+1] = Sujeet
	Events[#Events+1] = Demir
	Events[#Events+1] = Dyle
	Events[#Events+1] = Patti
	Events[#Events+1] = Richard
	Events[#Events+1] = Pat
	Events[#Events+1] = Caitlin
else
	Events[#Events+1] = Sami		-- 8
	Events[#Events+1] = MadMatt		-- 9
	Events[#Events+1] = Archi		-- 10
	Events[#Events+1] = LittleMatt	-- 11
end

return Events